#pragma once

#include <iostream>
#include <string>
#include <vector>
#include <list>
#include <set>

using namespace std;

/****************************************************
@author: Wan-Lei Zhao
@date: 2006-Nov
@date: modified in 2026-Jan

In charge of string operations

All rights are reserved by the author
***************************************************/

class VString
{
private:
    static void subbtw(char dest[], const char src[],
                         const int start, const int end);
    static void replase(char src[], const char ch, const char nwch);

public:
    VString();


    static bool startWith(const char *str, const char *pttn);
    static bool endWith(const char str[],  const char end[]);
    static void trimEnd(char *line,   const char ch);
    static void trimHead(char *line,  const char ch);
    static void trimAfter(char *line, const char ch);
    static void trimStops(char *line);

    static int  firstIndexof(const char *src, const char ch);
    static int  lastIndexof(const char *src,  const char ch);
    static int  parse_words(const char *str, vector<int> &nums);
    static int  countsof(string text, const char ch);

    static void parseLine(const char *line, const char spliter, set<int> &regTab);
    static set<unsigned int> parseLine(const char *line, const char spliter);
    static void parseLine(const char *line, const char spliter, vector<float> &vals);
    static void str2float(const char *line, const char spliter, vector<float> &Vals);

    static bool existFile(const char *fn);
    static bool existDir(const char  *dir);
    static bool validatePath(const char *path);

    static bool parseFName(char fname[], const char path[]);
    static bool parseDIR(char dirname[], const char path[]);
    static bool parsePath(char fname[],  const char path[]);
    static bool validFName(const char fname[]);
    static void toUpper(char str[]);
    static void toLower(char str[]);

    static const char *time2Str(const int seconds);
    static void time2Str(char *tmStr, const int seconds);

    static void test();
    virtual ~VString(){}

};
