#pragma once

#include "abstractpquantizer.h"

#include <iostream>
#include <fstream>
#include <string>
#include <vector>

using namespace std;

/****************************************************
 * 
@author: Wan-Lei Zhao
@date: 2012-Aug
@date: modified in 2026-Jan


Implementation of (multi-dimensional) NN search by
product-quantizer (PQ)

Please refer to following paper for variables defined in the code.

Product quantization for nearest neighbor search, Herve J., et al.

The naming about the variables and functions is inline with the original
paper as much as possible.

All rights are reserved by the author.
*****************************************************/

class PQnnSearch: public AbstractPQuantizer
{
    protected:
        static const unsigned topk0;

    private:
        unsigned long imgNum;

        ///where to keep the reference items for non-IVF ADC case;
        unsigned char *refPQCodes;
        float *ADCTab;

    public:
        PQnnSearch(string vocabFn, string refPQFn);

        /**NNS*/
        std::vector<std::vector<size_t> > performADCQuery(string srcFn, string dstFn, const unsigned topk);

        /**to support asymmetric query (ADC)**/
        void updateADCTab(const float *qry,  const unsigned int seg0);

        virtual ~PQnnSearch();
        static void test();
};