#pragma once

#include <iostream>
#include <cstring>
#include <string>
#include <vector>

#include "abstractpquantizer.h"

using namespace std;

/****************************************************
@author: Wan-Lei Zhao
@date: 2012-Aug
@date: modified in 2026-Jan

In charge of encoding vector into PQ codes

All rights are reserved by the author.
***************************************************/

class PQEncoder : public AbstractPQuantizer
{

public:
    PQEncoder(string vocabFn);
    bool quantzPQ(const float *vect, const unsigned nSeg, unsigned codes[]);
    bool performPQEncodeMat(string srcFn, string dstFn);

    static void test();

    virtual ~PQEncoder()
    {
        cout << "\nRelease allocated memories ...... ";
        if (pqVocab != nullptr)
        {
            delete[] pqVocab;
            this->pqVocab = nullptr;
        }

        cout << "done\n";
    }
};
