#include "pqencoder.h"
#include "vstring.h"

#include <filesystem>
#include <dirent.h>
#include <fstream>
#include <cstring>
#include <string>
#include <cassert>
#include <cmath>
#include <map>

const int AbstractPQuantizer::verbose = 1;

using namespace std;

PQEncoder::PQEncoder(string vocabFn)
{
    cout<<"Qunatization Option ............. PQ\n";

    cout<<"Loading Product quantizer ....... ";
    this->pqVocab = AbstractPQuantizer::loadPQVocab(vocabFn, this->pqDim, this->pqNum,  this->nSeg0);
    
    assert(this->pqVocab);
    cout<<this->pqNum<<": "<<this->pqDim<<"x"<<this->nSeg0<<endl;

    if(this->pqDim == 0 || this->pqNum == 0)
    {
        cout<<"Initlizing vocabularies failed!\n";
        exit(0);
    }

    /********initialize for nnSearch ***************/
    this->ftDim = this->pqDim*this->nSeg0;
    cout << "Dim ............................. " << this->ftDim << std::endl;
    cout << "PQ dim .......................... " << this->pqDim << std::endl;
    cout << "PQ Size ......................... " << this->pqNum << std::endl;

}

bool PQEncoder::performPQEncodeMat(string srcFn, string dstFn)
{
    if(!VString::existFile(srcFn.c_str()))
    {
        cout << "Source file '" << srcFn << "' cannot open!\n";
        exit(0);
    }

    ofstream *pqcStrm = new ofstream(dstFn, ios::out);
    if(!pqcStrm->is_open())
    {
        cout << "File '" << dstFn << "' cannot open for writing!\n";
        pqcStrm->close();
        exit(0);
    }

    unsigned int vnum = 0, i = 0, di = 0, sz = 0, k = 0;
    float *feat = new float[this->ftDim];
    unsigned int *pqcodes = new unsigned int[this->nSeg0 + 1];

    cout<< "Encode vectors into PQ .......... '" << srcFn <<"'\n";
    ifstream *inStrm = new ifstream(srcFn, ios::in|ios::binary);
    if (!inStrm->is_open())
    {
        std::cout << "File '" << srcFn << "' cannot open for read!\n";
        exit(0);
    }
    
    inStrm->read((char*)&di, sizeof(unsigned));
    assert(di == this->ftDim);
    unsigned szRow = sizeof(unsigned) + sizeof(float)*di;
    unsigned long fileSz = std::filesystem::file_size(srcFn);
    unsigned nRow =  fileSz/szRow;
    
    (*pqcStrm) << nRow << " " << this->nSeg0 << std::endl;

    while(!inStrm->eof())
    {
        inStrm->read((char*)feat, sizeof(float)*this->ftDim);
        inStrm->read((char*)&di, sizeof(unsigned));

        assert(di == this->ftDim);

        this->quantzPQ(feat, this->nSeg0, pqcodes);

        for(i = 0; i < this->nSeg0; i++)
        {
            (*pqcStrm) << pqcodes[i] << " ";
        }
        (*pqcStrm) << endl;
        memset(feat, 0, sizeof(float)*this->ftDim);
        vnum++;
        printf("\r\r\t%6d", vnum);
    }
    inStrm->close();
    pqcStrm->close();
    std::cout << endl;

    delete [] feat;
    delete [] pqcodes;
    pqcodes = nullptr;
    feat = nullptr;

    return true;
}

bool PQEncoder::quantzPQ(const float *vect, const unsigned nSeg, unsigned codes[])
{
    assert(this->pqVocab);
    assert(codes);
    assert(vect);

    const float *p_pqVocab = nullptr, *ppq = nullptr;
    unsigned long locs = 0, i = 0, di = 0;
    float dst = 0, delta = 0, mdst = 0;
    unsigned s = 0, nnIdx = 0;

    for(s = 0; s < nSeg; s++)
    {
        p_pqVocab = this->pqVocab + s*this->pqDim*this->pqNum;
        locs      = s*this->pqDim;
        mdst      = RAND_MAX;
        nnIdx     = 0;
        for(i = 0; i < this->pqNum; i++)
        {
            ppq = p_pqVocab + i*this->pqDim;
            dst = 0;
            /** 
            *filling your codes here
            **/
        }
        codes[s] = nnIdx;
    }

    return true;
}

void PQEncoder::test()
{
    /*****modify the following paths to your appropriate paths */
    string srcFn   = "/home/wlzhao/datasets/bignn/sift1m/sift1m_base.fvecs";
    string srcFn1   = "/home/wlzhao/datasets/bignn/sift1m/pq/sample.fvecs";
    string dstFn   = "/home/wlzhao/datasets/bignn/sift1m/pq/sift1m_base_pq.txt";
    string vocabFn = "/home/wlzhao/datasets/bignn/sift1m/pq/vocab_pqk256m8.txt";

    PQEncoder *encoder = new PQEncoder(vocabFn);
    encoder->performPQEncodeMat(srcFn, dstFn);
}
