#include "pqcodeloader.h"

#include <filesystem>
#include <iostream>
#include <fstream>
#include <cstdlib>
#include <string>
#include <cstdio>
#include <cmath>

using namespace std;


/**load PQ codes for ADC search**/
unsigned char* PQCodeLoader::loadPQCodes(string srcFn, unsigned long &refImgSz, unsigned &dv)
{
    cout<<"Loading PQ codes file ............ PQ\n";
    unsigned int Num = 0, Dim = 0, i = 0, j = 0, code = 0;
    unsigned char * pqCodes = nullptr, pqcode = 0;
    unsigned long imgID = 0;
    unsigned long pp = 0;

    ifstream *inStrm = nullptr;
    inStrm = new ifstream(srcFn);

    if(inStrm->fail())
    {
        cout<<"File '"<<srcFn<<"' cannot open for read!"<<endl;
        delete inStrm;
        exit(0);
    }
    
    if(!inStrm->eof())
    {
        (*inStrm) >> Num; (*inStrm)>>Dim;
        pqCodes = new u_char[Num*Dim];
        for(i = 0; i < Num && !inStrm->eof(); i++)
        {
            for(j = 0; j < Dim; j++, pp++)
            {
                (*inStrm) >> code;
                pqcode = code;
                pqCodes[pp] = pqcode;
            }///for(j)
        }///for(i)
        imgID += Num;
        cout << "\r\r\r\t" << imgID;
    }///if(inStrm)
    inStrm->close();
    delete inStrm;
    cout << endl;
    dv = Dim;
    refImgSz = imgID;
    return pqCodes;
}

void PQCodeLoader::test()
{
    string srcFn1 = "/home/wlzhao/datasets/bignn/sift1m/pq/sift1m_pq.txt";
    string srcFn2 = "/home/wlzhao/datasets/bignn/sift1m/pq/sift1m_query_pq.txt";
    unsigned long num = 0;
    unsigned dv = 0, i = 9998;

    u_char *pqCodes = PQCodeLoader::loadPQCodes(srcFn2, num, dv);
    std::cout << std::endl;
    for(unsigned j = 0; j < dv; j++)
    {
        std::cout << (unsigned) pqCodes[dv*i+j] << " ";
    }
    std::cout << std::endl;
}

