#pragma once

#include <iostream>
#include <fstream>
#include <vector>
#include <string>

using namespace std;

/****************************************************
@author: Wan-Lei Zhao
@date: 2022-Jul
@date: modified in 2026-Jan

In charge of evaluating NN search performance

All rights are reserved by the author.
***************************************************/

class Evaluator
{
    std::vector<std::vector<size_t>> knng;

private:
    unsigned loadGroundTruth(string gtFn, std::vector<std::vector<size_t>> &gtNNs)
    {
        std::ifstream inStrm(gtFn, ios::in);
        if (!inStrm.is_open())
        {
            std::cout << "File '" << gtFn << "' cannot open! " << std::endl;
            exit(0);
        }
        size_t nb = 0, num = 0;
        unsigned  idx = 0;
        while (!inStrm.eof())
        {
            inStrm >> num;
            if ( num == 0)
            continue;
            std::vector<size_t> nbs;
            for (size_t i = 0; i < num; i++)
            {
                inStrm >> nb;
                nbs.emplace_back(nb);
            }
            gtNNs.push_back(nbs);
            num = 0;
            idx++;
        }

        inStrm.close();
        return idx;
    }

public:
    Evaluator(string gtFn)
    {
        unsigned nQuery = this->loadGroundTruth(gtFn, this->knng);
        std::cout << "Num. of queries in GT ............ " << nQuery << std::endl;
    }

    float getRecall(std::vector<std::vector<size_t>> &anng, size_t checkK)
    {
        size_t hit = 0;
        size_t checkN = std::min(anng.size(), this->knng.size());

        for (size_t i = 0; i < checkN; ++i)
        {
            auto &ann = anng[i];
            auto &knn = this->knng[i];
            for (size_t j = 0; j < 1; ++j)
            {
                auto idx = ann[j];
                for (size_t l = 0; l < checkK; ++l)
                {
                    auto nb = knn[l];
                    if (idx == nb)
                    {
                        ++hit;
                        break;
                    }
                }
            }
        }
        return (1.0 * hit) / checkN;
    }

    static void test()
    {
        string gtFn = "/home/wlzhao/datasets/bignn/sift1m/pq/sift1m_gt.txt";
        Evaluator eval(gtFn);

    }
};