#pragma once

#include <cstring>
#include <string>
#include <vector>
#include <map>
#include <set>

using namespace std;


/****************************************************
@author: Wan-Lei Zhao
@date: 2012-Aug
@date: modified in 2026-Jan

In charge of encode vector into PQ codes

All rights are reserved by the author
***************************************************/

class AbstractPQuantizer
{
public:
    AbstractPQuantizer();
    virtual ~AbstractPQuantizer();

protected:
    static const int verbose;
    static const unsigned int FNLEN = 1024;

protected:
    unsigned nSeg0, pqDim, pqNum, ftDim;

    /**
     * nSeg0: number of segments/subvectors
     * pqDim: the dimension of subvector
     * pqNum: the size of PQ codebook/vocabulary, pqNum = 256 by default
     * ftDim: original vector dimension
     */

    const float *pqVocab;
    /***
     * 
     * pqVocab: pq codebook/vocabulary, it is comprised by nSeg0 of 
     * codebooks, the size of each codebook is pqNum x pqDim
     * 
     */

protected:
    bool  _timeon_;


public:
    static float *loadPQVocab(string vocabFn0, unsigned &vdim2, unsigned &vsize2, unsigned &segment);
    static float *loadfvecs(std::string srcFn, size_t &nRow, size_t &nDim);
    static void   writefvecs(std::string dstFn, const unsigned nRow, const unsigned nDim, const float *mat);
    static void   test();
};


