#include "abstractpquantizer.h"

#include <iostream>
#include <fstream>
#include <cassert>

using namespace std;

AbstractPQuantizer::AbstractPQuantizer()
{
    this->pqVocab = nullptr;
}

float *AbstractPQuantizer::loadPQVocab(string vocabFn, unsigned &vdim2, unsigned &vsize2, unsigned &segment)
{
    ifstream *inStrm = new ifstream(vocabFn);
    if(!inStrm->is_open())
    {
        cout<<"Open file '"<<vocabFn<<" failed!" << endl;
        exit(0);
    }

    unsigned int irow = 0, idim = 0, loc = 0;
    unsigned int vsize1 = 0, vdim1 = 0;
    float vocab1 = 0;

    (*inStrm) >> vsize2;
    (*inStrm) >> vdim2;
    (*inStrm) >> segment;

    float *vocab2 = new float[vdim2*vsize2*segment];
    unsigned int iseg = 0, loc0 = 0;

    for(iseg = 0; iseg < segment; iseg++)
    {
        loc0 = iseg*vsize2*vdim2;
        for(irow = 0; irow < vsize2; irow++)
        {
            loc = loc0 + irow*vdim2;
            for(idim = 0; idim < vdim2; idim++)
            {
                (*inStrm)  >> vocab2[loc + idim];
            }
        }
    }

    inStrm->close();
    return vocab2;
}

float *AbstractPQuantizer::loadfvecs(std::string srcFn, size_t &nRow, size_t &nDim)
{
        std::ifstream inStrm(srcFn, std::ios::in | std::ios::binary);

        if (!inStrm.is_open())
        {
            std::cerr << "File '" << srcFn << "' cannot open for read!\n";
            exit(0);
        }

        inStrm.read((char *)&nDim, sizeof(unsigned));
        inStrm.seekg(0, std::ios::end);
        size_t fileSize = inStrm.tellg();
        nRow = fileSize / (sizeof(float) * nDim + sizeof(unsigned));
        float *mat = new float[nRow * nDim];
        float *vect = new float[nDim];
        size_t j = 0, nline = 0;
        inStrm.clear();
        inStrm.seekg(0, std::ios::beg);
        while (inStrm.read((char *)&nDim, sizeof(unsigned)))
        {
            inStrm.read((char *)vect, sizeof(float) * nDim);
            for (size_t i = 0; i < nDim; i++, j++)
            {
                mat[j] = vect[i];
            }
            nline++;
        }
        inStrm.close();
        delete[] vect;
        vect = nullptr;
        return mat;
}

void AbstractPQuantizer::writefvecs(std::string dstFn, const unsigned nRow, const unsigned nDim, const float *mat)
{
        std::ofstream outStrm(dstFn, std::ios::out | std::ios::binary);

        if (!outStrm.is_open())
        {
            std::cerr << "File '" << dstFn << "' cannot open for write!\n";
            exit(0);
        }

        for(unsigned i = 0; i < nRow; i++)
        {
            outStrm.write((char *)&nDim, sizeof(unsigned));
            outStrm.write((char *)(mat + i*nDim), sizeof(float) * nDim);
        }
        outStrm.close();
        return ;
}

void AbstractPQuantizer::test()
{
    string srcFn = "/home/wlzhao/datasets/bignn/sift1m/pq/sift1m_base.fvecs";
    string dstFn = "/home/wlzhao/datasets/bignn/sift1m/pq/sample.fvecs";
    size_t nRow = 0, nDim = 0;
    float *mat = AbstractPQuantizer::loadfvecs(srcFn, nRow, nDim);
    AbstractPQuantizer::writefvecs(dstFn, 32, 128, mat);
    delete [] mat;
    mat = nullptr;
}

AbstractPQuantizer::~AbstractPQuantizer()
{
    cout<<"\nRelease Visual words ............ ";
    if (pqVocab != nullptr)
    {
        delete [] pqVocab;
        pqVocab = nullptr;
    }

    cout<<"done\n";
}
